<?php

$config = array(
    /**
    * Wording
    */
    'plugin/title' => '1-Click Video Site Builder',

    /**
    * Links
    */
    'plugin/site/url' => 'http://1clickvideositebuilder.com',
    'plugin/author/url' => 'http://www.georgekatsoudas.com',

    /**
    * Requirements
    */
    'requirement/php/version/min' => '5.2',
    'requirement/wordpress/version/min' => '3.7',
    'requirement/wordpress/user/capability' => 'publish_posts',

    /**
     * Update settings
     */
    'update/product/name' => ytg_Core::$app->slug,
    'update/check/interval' => 12, // Check updates at least X hours after last check

    /**
     * Activate settings
     */
    'activate/api/url' => 'http://activate.wppluginupdate.com/inquiry/receive/',
    'activate/verify/interval' => 604800, // weekly
    'activate/verifyRetry/interval' => 86400, // daily,
    'activate/verifyRetry/maxCount' => 3,

    /**
    * Components
    */
    'components' => array(
        'postTypes' => array(
            'excludeContentTypes' => array('attachment', 'page'),
            'listValueProperty' => 'name',
        ),
    ),
    'bootstrap' => array(
        'setup',
        'update',
        'assets',
        'activate',
        'helper',
        'postTemplate',
        'frontend',
    ),

    //'admin/menu/defaultPosition' => 3,

    'option/default/searchMode' => 'keyword',

    // Default option values
    'option/default/sortOrder' => 'viewCount',
    'option/default/publicationMethod' => 'draft',
    'option/default/maxCount' => 10,
    'option/default/postsPerWeek' => 7,
    //'option/default/postCategories' => array(1),

    'option/default/playerHeight' => 360,
    'option/default/playerAutoPlay' => FALSE,
    'option/default/playerShowRelated' => FALSE,
    'option/default/playerShowAnnotations' => FALSE,
    'option/default/generatorFeaturedImages' => FALSE,
    'option/default/generatorRemoveLinks' => TRUE,
    'option/default/displayCloakLinks' => TRUE,
    'option/default/displayCloakingDirectory' => 'recommends',
    'option/default/spinrewriterConfidenceLevel' => 'medium',

    'option/default/channelCheckInterval' => 1,

    'option/default/postType' => 'post',

    'template/default/content' => "<p>[video-player]</p>\n\n<p>[description]</p>",

    // WYSIWYG editor options
    'editor/options/default' => array(
        'toolbars' => array(
            1 => array(
                'bold',
                'italic',
                'underline',
                'fontselect',
                'fontsizeselect',
                'forecolor',
            ),
            2 => array(
                'alignleft',    // 4.x name
                'justifyleft',  // 3.x name
                'aligncenter',  // 4.x name
                'justifycenter',// 3.x name
                'alignright',   // 4.x name
                'justifyright', // 3.x name
                'alignjustify', // 4.x name
                'justifyfull',  // 3.x name
                'bullist',
                'numlist',
                'link',
                'unlink',
                'backcolor',
                'undo',
                'redo',
            ),
        ),
        'fonts' => array(
            'Arial' => 'arial,helvetica,sans-serif',
            'Arial_Black' => 'arial black,avant garde',
            'Courier_New' => 'courier new,courier',
            'Georgia' => 'georgia,palatino',
            'Helvetica' => 'helvetica',
            'Impact' => 'impact,chicago',
            'Tahoma' => 'tahoma,arial,helvetica,sans-serif',
            'Times_New_Roman' => 'times new roman,times',
            'Verdana' => 'verdana,geneva',
        ),

        'quicktags' => array(
            'buttons' => 'strong,em,link,block,del,ins,img,ul,ol,li,code,close',
        ),

        'wpautop' => FALSE,

        'unhide_kitchensink' => TRUE,

        'tinymce' => array(
            'cleanup_on_startup' => FALSE,
            'trim_span_elements' => FALSE,
            'verify_html' => FALSE,
            'cleanup' => FALSE,
            'convert_urls' => FALSE,

            'resize' => FALSE,
            'wp_autoresize_on' => FALSE,

            'formats' => "{
                alignleft : [
                    {selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,form', styles : {textAlign : 'left'}},
                    {selector : 'img:not(.mceItemIframe),table', classes : 'alignleft'}
                ],
                aligncenter : [
                    {selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,form', styles : {textAlign : 'center'}},
                    {selector : 'img:not(.mceItemIframe),table', classes : 'aligncenter'}
                ],
                alignright : [
                    {selector : 'p,h1,h2,h3,h4,h5,h6,td,th,div,ul,ol,li,form', styles : {textAlign : 'right'}},
                    {selector : 'img:not(.mceItemIframe),table', classes : 'alignright'}
                ],
                strikethrough : {inline : 'del'}
            }",
            'fontsize_formats' => '10pt 12pt 14pt 16pt 18pt 24pt 36pt 48pt',
        ),
        'default_editor' => 'tinymce',
    ),

    'edition' => 'one-click-video-site-builder' == ytg_Core::$app->slug
        ? 'pro'
        : 'basic',
);

if ('pro' == $config['edition']) {
    $config['plugin/title'] = '1-Click Video Site Builder PRO';
    $config['bootstrap'][] = 'cron';
}

if (is_admin()) {
    $config['bootstrap'][] = 'admin';
    $config['bootstrap'][] = 'ajax';
}

if (ytg_Core::$app->demo) {
    $config['update/product/name'] .= '-demo';
    $config['plugin/title'] = '1-Click Video Site Builder Demo';
}

return $config;