<?php

ytg_Core::load('Framework_Model_Form_Options');
ytg_Core::load('Framework_Helper_Filter');

class ytg_Model_Form_Options extends ytg_Framework_Model_Form_Options
{
    public $youtubeApiKey;

    public $playerWidth;
    public $playerHeight;
    public $playerAutoPlay;
    public $playerShowRelated;
    public $playerShowAnnotations;

    public $generatorFeaturedImages;
    public $generatorRemoveLinks;
    public $generatorFetchComments;

    public $displayCloakLinks;
    public $displayCloakingDirectory;
    public $displaySuppressFeaturedImage;

    public $spinrewriterEmail;
    public $spinrewriterApiKey;
    public $spinrewriterProtectedTerms;
    public $spinrewriterConfidenceLevel;
    public $spinrewriterDisable;

    public $onlywireUsername;
    public $onlywirePassword;
    public $onlywireServices = array();

    public $onlywireServiceList;

    public $attributeProperties = array(
        'youtubeApiKey' => array('help' => FALSE),
        'playerWidth' => array('help' => FALSE),
        'playerHeight' => array('help' => FALSE),
        'playerAutoPlay' => array('help' => FALSE),
        'playerShowRelated' => array('help' => FALSE),
        'playerShowAnnotations' => array('help' => FALSE),
        'displayCloakingDirectory' => array('help' => FALSE),
        'spinrewriterEmail' => array('help' => FALSE),
        'spinrewriterApiKey' => array('help' => FALSE),
        'spinrewriterDisable' => array('help' => FALSE),
        'onlywireUsername' => array('help' => FALSE),
        'onlywirePassword' => array('help' => FALSE),
    );

    public $errors = array();

    public function loadOnlywireServices($refresh = FALSE)
    {
        /** @var ytg_Component_Client_Onlywire $client */
        $client = ytg_Core::$app->client_Onlywire;

        if ($refresh) {
            $client->resetServiceCache();
        }

        $client->username = $this->onlywireUsername;
        $client->password = $this->onlywirePassword;
        if ($this->getHasOnlywireServices()) {
            try {
                $this->onlywireServiceList = $client->getServiceListGrouped();
                if (!is_array($this->onlywireServices)) {
                    $this->onlywireServices = isset($this->errors['onlywire'])
                        ? array()
                        : $client->getServiceIds();
                }
                unset($this->errors['onlywire']);
            } catch (ytg_Component_Client_Onlywire_Exception $e) {
                $this->errors['onlywire']
                    = "Cannot retrieve OnlyWire profiles list: {$e->getMessage()}";
            }
        } else {
            $this->onlywireServiceList = NULL;
        }
    }

    public function beforeValidate()
    {
        parent::beforeValidate();

        if ($this->onlywireUsername != $this->io->onlywireUsername) {
            // Username changed, reset the service list
            $this->onlywireServices = NULL;
            $this->loadOnlywireServices(TRUE);
        } else {
            $this->loadOnlywireServices(
                'refresh-onlywire-services' == $this->scenario);
        }

        return TRUE;
    }

    public $attributePropertyDefaults = array(
        'help' => TRUE,
    );

    public function rules()
    {
        return array(
            array('youtubeApiKey', 'filter',
                'filter' => 'stripslashes',
                'except' => 'refresh-onlywire-services',
            ),
            array('youtubeApiKey', 'trim', 'except' => 'refresh-onlywire-services'),
            array('youtubeApiKey', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines'),
                'except' => 'refresh-onlywire-services',
            ),
            array('youtubeApiKey', 'required', 'except' => 'refresh-onlywire-services'),

            array('playerWidth', 'trim', 'except' => 'refresh-onlywire-services'),
            array('playerWidth', 'integer', 'min' => 10, 'except' => 'refresh-onlywire-services'),
            array('playerWidth', 'default', 'except' => 'refresh-onlywire-services'),

            array('playerHeight', 'trim', 'except' => 'refresh-onlywire-services'),
            array('playerHeight', 'integer', 'min' => 10, 'except' => 'refresh-onlywire-services'),
            array('playerHeight', 'required', 'except' => 'refresh-onlywire-services'),

            array('playerAutoPlay', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('playerAutoPlay', 'required', 'except' => 'refresh-onlywire-services'),

            array('playerShowRelated', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('playerShowRelated', 'required', 'except' => 'refresh-onlywire-services'),

            array('playerShowAnnotations', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('playerShowAnnotations', 'required', 'except' => 'refresh-onlywire-services'),

            array('generatorFeaturedImages', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('generatorFeaturedImages',
                'required',
                'except' => 'refresh-onlywire-services',
            ),

            array('displaySuppressFeaturedImage', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('displaySuppressFeaturedImage',
                'required',
                'except' => 'refresh-onlywire-services',
            ),

            array('generatorRemoveLinks', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('generatorRemoveLinks',
                'pro' == ytg_Core::config('edition')? 'required' : 'default',
                'except' => 'refresh-onlywire-services',
            ),

            array('generatorFetchComments', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('generatorFetchComments',
                'pro' == ytg_Core::config('edition')? 'required' : 'default',
                'except' => 'refresh-onlywire-services',
            ),

            array('displayCloakLinks', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('displayCloakLinks',
                'pro' == ytg_Core::config('edition')? 'required' : 'default',
                'except' => 'refresh-onlywire-services',
            ),

            array('displayCloakingDirectory', 'filter',
                'filter' => 'stripslashes',
                'when' => array($this, '_getDisplayCloakingDirectoryEnabled'),
                'except' => 'refresh-onlywire-services',
            ),
            array('displayCloakingDirectory', 'trim',
                'when' => array($this, '_getDisplayCloakingDirectoryEnabled'),
                'except' => 'refresh-onlywire-services',
            ),
            array('displayCloakingDirectory', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines'),
                'except' => 'refresh-onlywire-services',
                'when' => array($this, '_getDisplayCloakingDirectoryEnabled'),
            ),
            array('displayCloakingDirectory', 'default',
                'value' => ytg_Core::$app->config('option/default/displayCloakingDirectory'),
                'except' => 'refresh-onlywire-services',
            ),

            array('spinrewriterEmail', 'filter',
                'filter' => 'stripslashes',
                'except' => 'refresh-onlywire-services',
            ),
            array('spinrewriterEmail', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines'),
                'except' => 'refresh-onlywire-services',
            ),
            array('spinrewriterEmail', 'trim', 'except' => 'refresh-onlywire-services'),
            array('spinrewriterEmail', 'default', 'except' => 'refresh-onlywire-services'),

            array('spinrewriterApiKey', 'filter',
                'filter' => 'stripslashes',
                'except' => 'refresh-onlywire-services',
            ),
            array('spinrewriterApiKey', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines'),
                'except' => 'refresh-onlywire-services',
            ),
            array('spinrewriterApiKey', 'trim', 'except' => 'refresh-onlywire-services'),
            array('spinrewriterApiKey', 'default', 'except' => 'refresh-onlywire-services'),

            array('spinrewriterProtectedTerms', 'filter',
                'filter' => 'stripslashes',
                'except' => 'refresh-onlywire-services',
            ),
            array('spinrewriterProtectedTerms', 'trim', 'except' => 'refresh-onlywire-services'),
            array('spinrewriterProtectedTerms', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'filterList'),
                'except' => 'refresh-onlywire-services',
            ),
            array('spinrewriterProtectedTerms', 'default', 'except' => 'refresh-onlywire-services'),

            array('spinrewriterConfidenceLevel', 'in',
                'range' => array_keys($this->getSpinrewriterConfidenceLevelList()),
                'except' => 'refresh-onlywire-services',
            ),
            array('spinrewriterConfidenceLevel',
                'default',
                'value' => ytg_Core::$app->config('option/default/spinrewriterConfidenceLevel'),
                'except' => 'refresh-onlywire-services',
            ),

            array('spinrewriterDisable', 'boolean', 'except' => 'refresh-onlywire-services'),
            array('spinrewriterDisable',
                'pro' == ytg_Core::config('edition')? 'required' : 'default',
                'except' => 'refresh-onlywire-services',
            ),

            array('onlywireUsername', 'filter',
                'filter' => 'stripslashes',
            ),
            array('onlywireUsername', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines'),
            ),
            array('onlywireUsername', 'trim'),
            array('onlywireUsername', 'default'),

            array('onlywirePassword', 'filter', 'filter' => 'stripslashes'),
            array('onlywirePassword', 'filter',
                    'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines'),
            ),
            array('onlywirePassword', 'trim'),
            array('onlywirePassword', 'default'),

            array('onlywireServices', 'inline',
                'method' => '_validateOnlywireServices',
                'when' => array($this, 'getHasOnlywireServices'),
                'except' => 'refresh-onlywire-services',
            ),
        );
    }

    public function attributeLabels()
    {
        return array(
            'youtubeApiKey' => 'Google YouTube API Key',

            'playerWidth' => 'Video Width',
            'playerHeight' => 'Video Height',
            'playerAutoPlay' => 'Autoplay videos',
            'playerShowRelated' => 'Show related videos',
            'playerShowAnnotations' => 'Show annotations',

            'generatorFeaturedImages' => 'Download video thumbnails as featured images',
            'generatorRemoveLinks' => 'Remove links from YouTube descriptions',
            'generatorFetchComments' => 'Fetch YouTube comments',

            'displayCloakLinks' => 'Cloak your links',
            'displayCloakingDirectory' => 'Cloaking directory',
            'displaySuppressFeaturedImage' => 'Hide featured images on posts created by this plugin',

            'spinrewriterEmail' => 'SpinRewriter Email',
            'spinrewriterApiKey' => 'SpinRewriter API Key',
            'spinrewriterProtectedTerms' => 'Ignore Words',
            'spinrewriterConfidenceLevel' => 'Text Quality',
            'spinrewriterDisable' => 'Disable text spinning',

            'onlywireUsername' => 'OnlyWire Username',
            'onlywirePassword' => 'OnlyWire Password',
            'onlywireServices' => 'OnlyWire Social-Network Profiles To Post To',
        );
    }

    public function getSpinrewriterConfidenceLevelList()
    {
        return array(
            'low' => 'More Unique, less readable',
            'medium' => 'Normal',
            'high' => 'Less unique, more readable',
        );
    }

    public function getHasOnlywireServices()
    {
        return ytg_Core::$app->client_Onlywire->hasCredentials;
    }

    public function _validateOnlywireServices()
    {
        $value = $this->onlywireServices;

        if (!is_array($value)) {
            $this->addError('onlywireServices', 'Parameter "onlywireServices" should be array');
            return;
        }

        $ids = ytg_Core::$app->client_Onlywire->getServiceIds();
        $modified = FALSE;
        foreach ($this->onlywireServices as $key=>$id) {
            if (!in_array($id, $ids)) {
                unset($this->onlywireServices[$key]);
                $modified = TRUE;
            }
        }

        if ($modified) {
            $this->onlywireServices = array_values($this->onlywireServices);
        }
    }

    public function _getDisplayCloakingDirectoryEnabled()
    {
        return (bool) $this->displayCloakLinks;
    }

    public function beforeSave(&$attributes)
    {
        parent::beforeSave($attributes);

        if (!$this->_getDisplayCloakingDirectoryEnabled()) {
            $keys = array_flip($attributes);
            unset($keys['displayCloakingDirectory']);
            $attributes = array_keys($keys);
        }
    }
}