<?php

ytg_Core::load('Framework_Model_Form_Options');
ytg_Core::load('Framework_Helper_Filter');

class ytg_Model_Form_ChannelOptions extends ytg_Framework_Model_Form_Options
{
    public $channelCheckInterval;

    public $attributeProperties = array(
        'channelCheckInterval' => array('help' => FALSE),
    );

    public $attributePropertyDefaults = array(
        'help' => TRUE,
    );

    public function rules()
    {
        return array(
            array('channelCheckInterval', 'filter',
                'filter' => array('ytg_Framework_Helper_Filter', 'stripNewLines')),
            array('channelCheckInterval', 'trim'),
            array('channelCheckInterval', 'integer', 'min' => 1),
            array('channelCheckInterval', 'required'),
        );
    }

    public function attributeLabels()
    {
        return array(
            'channelCheckInterval' => 'Look for new videos from these channels every X day(s)',
        );
    }
}