<?php

class ytg_Helper_YouTube
{
    public static $patterns = array(
        'video' => array(
            '~/(?:v/|watch\?v=|embed/)([\w\-]+)~is',
            '~/embed/([\w\-]+)~is',
            '~/([\w\-]+)~is',
        ),
        'channel' => array(
            '~/channel/([^/?]+)~is',
        ),
    );

    public static function filter($value, $type = 'video')
    {
        foreach (self::$patterns[$type] as $pattern) {
            if (preg_match($pattern, $value, $match)) {
                return $match[1];
            }
        }

        return $value;
    }

    public static function filterVideo($value)
    {
        return self::filter($value, 'video');
    }

    public static function filterChannel($value)
    {
        return self::filter($value, 'channel');
    }
}