<?php
ytg_Core::load('Controller_Base_Admin');

class ytg_Controller_Template extends ytg_Controller_Base_Admin
{
    public function actionIndex()
    {
        return $this->render('template/index');
    }

    public function actionAdd()
    {
        /**
         * @var ytg_Model_Template $model
         */
        $model = ytg_Core::create('Model_Template');

        if ($_POST) {
            $this->_handleFormParameters($model);

            if ($model->load($_POST) && $model->save()) {
                ytg_Core::$app->view->messages()
                    ->add("New template '{$model->name}' has been added.");
                return $this->redirect(array(
                    'action' => 'edit',
                    'id' => $model->id,
                ));
            } else {
                $this->_displayFormErrors($model);
            }
        }

        return $this->render('template/add', compact('model'));
    }

    public function actionEdit($id)
    {
        /**
         * @var ytg_Model_Template $model
         */
        $model = $this->_findModel($id);

        if ($_POST) {
            $this->_handleFormParameters($model);

            if ($model->load($_POST) && $model->save()) {
                ytg_Core::$app->view->messages()
                    ->add("The template '{$model->name}' has been updated.");
            } else {
                $this->_displayFormErrors($model);
            }
        }

        return $this->render('template/edit', compact('model'));
    }

    protected function _handleFormParameters(ytg_Model_Template $model)
    {
        $this->_localizeGlobalParameter('content', $model->formName());
    }

    public function actionDelete($id)
    {
        $model = $this->_findModel($id);

        if (1 == $model->id) {
            ytg_Core::terminate('Could not delete default template', 403);
        }

        $model->delete();
        ytg_Core::$app->view->messages()->add("Template '{$model->name}' has been deleted.");

        if (isset($_REQUEST['return'])) {
            return  $this->redirect('home' == $_REQUEST['return']
                ? array()
                : $_REQUEST['return']);
        } else if (isset($_SERVER['HTTP_REFERER'])) {
            return $this->redirect($_SERVER['HTTP_REFERER']);
        }
        return $this->redirect(array());
    }

    public function actionPreview($id = NULL)
    {
        $this->layoutTemplate = NULL;

        $model = ytg_Core::$app->model('Model_Template')->find($id);

        echo $this->render('template/preview', compact('model'));
        exit;
    }

    /**
     * @param integer $id
     * @returns ytg_Model_Template
     */
    protected function _findModel($id)
    {
        $result = ytg_Core::model('Model_Template')->findOne($id);

        if (!$result) {
            ytg_Core::terminate('Template not found', 404);
        }

        return $result;
    }
}