<?php
ytg_Core::load('Framework_Controller_Metabox');

class ytg_Controller_Metabox extends ytg_Framework_Controller_Metabox
{
    public function actionDefault($post, $box)
    {
        if (!ytg_Core::$app->postTemplate->isOwnPost($post)) {
            return $this->render('metabox/default/not-supported');
        }

        /**
         * @var ytg_Model_Form_Metabox_Default $model
         */
        $model = ytg_Core::$app->create('Model_Form_Metabox_Default', array(
            'postId' => $post->ID,
        ));
        $model->refresh();

        return $this->render('metabox/default', compact('model'));
    }

    public function actionSave($postId)
    {
        /**
         * @var ytg_Model_Form_Metabox_Default $model
         */
        $model = ytg_Core::$app->create('Model_Form_Metabox_Default', array(
            'postId' => $postId,
        ));
        if ($model->load($_POST)) {
            if (!$model->save()) { 
                foreach ($model->getFirstErrors() as $error) {
                    ytg_Core::$app->view->messages()->add($error, 'error');
                }
            }
        }
    }
}