<?php
ytg_Core::load('Controller_Base_Admin');

class ytg_Controller_Channel extends ytg_Controller_Base_Admin
{
    public function actionIndex()
    {
        /**
         * @var $channelOptions ytg_Model_Form_ChannelOptions
         */
        $channelOptions = ytg_Core::create('Model_Form_ChannelOptions')->refresh();

        /**
         * @var $cpanel ytg_Component_Client_Cpanel
         */
        $cpanel = ytg_Core::$app->client_Cpanel;

        if ($_POST) {
            if ($cpanel->load($_POST)) {
                if ($cpanel->validate()) {
                    try {
                        $cpanel->addCronJob(ytg_Core::$app->cron->generateCronJob());
                        ytg_Core::$app->view->messages()->add('Cron job added successfully');
                    } catch (ytg_Component_Client_Cpanel_DuplicateException $e) {
                        ytg_Core::$app->view->messages()->add($e->getMessage(), 'warning');
                    } catch (ytg_Component_Client_Cpanel_Exception $e) {
                        $cpanel->addError('_general', "Error adding cron job: {$e->getMessage()}");

                    }
                }

                if ($cpanel->hasErrors()) {
                    $this->_displayFormErrors($cpanel);
                }
            }
        }

        return $this->render('channel/index', compact('channelOptions',
            'cpanel'));
    }

    public function actionAdd()
    {
        /**
         * @var ytg_Model_Channel $model
         */
        $model = ytg_Core::create('Model_Channel');

        if ($_POST) {
            $this->_handleFormParameters($model);

            if ($model->load($_POST) && $model->save()) {
                ytg_Core::$app->view->messages()
                    ->add("New channel '{$model->name}' has been added.");
                return $this->redirect(array(
                    'action' => 'edit',
                    'id' => $model->id,
                ));
            } else {
                $this->_displayFormErrors($model);
            }
        }

        return $this->render('channel/add', compact('model'));
    }

    public function actionEdit($id)
    {
        /**
         * @var ytg_Model_Channel $model
         */
        $model = $this->_findModel($id);

        if ($_POST) {
            $this->_handleFormParameters($model);

            if ($model->load($_POST) && $model->save()) {
                ytg_Core::$app->view->messages()
                    ->add("The channel '{$model->name}' has been updated.");
            } else {
                $this->_displayFormErrors($model);
            }
        }

        return $this->render('channel/edit', compact('model'));
    }

    protected function _handleFormParameters(ytg_Model_Channel $model)
    {
        if (!isset($_POST['post_category'])) {
            $_POST['post_category'] = array();
        }

        $this->_localizeGlobalParameter('post_category', $model->formName(),
            'categories');
    }

    protected function _handleCategoriesParameter(ytg_Model_Template $model)
    {
        $this->_localizeGlobalParameter('content', $model->formName());
    }

    public function actionDelete($id)
    {
        $model = $this->_findModel($id);

        $model->delete();
        ytg_Core::$app->view->messages()->add("Channel '{$model->name}' has been deleted.");

        if (isset($_REQUEST['return'])) {
            return  $this->redirect('home' == $_REQUEST['return']
                ? array()
                : $_REQUEST['return']);
        } else if (isset($_SERVER['HTTP_REFERER'])) {
            return $this->redirect($_SERVER['HTTP_REFERER']);
        }
        return $this->redirect(array());
    }

    public function actionCheck()
    {
        ytg_Core::$app->cron->checkChannels(TRUE);

        return $this->redirect(array());
    }

    /**
     * @param integer $id
     * @returns ytg_Model_Channel
     */
    protected function _findModel($id)
    {
        $result = ytg_Core::model('Model_Channel')->findOne($id);

        if (!$result) {
            ytg_Core::terminate('Channel not found', 404);
        }

        return $result;
    }
}