<?php
ytg_Core::load('Framework_Controller_Admin');

class ytg_Controller_Base_Admin extends ytg_Framework_Controller_Admin
{
    public function init()
    {
        parent::init();

        // Header tabs
        $this->layoutParams['headerTabs'] = array(
            'admin' => array(
                'label' => 'Admin',
                'url' => 'admin.php?page=' . ytg_Core::$app->slug . '-admin',
            ),
            'template' => array(
                'label' => 'Monetization Templates',
                'url' => 'admin.php?page=' . ytg_Core::$app->slug . '-template',
            ),
            'channel' => array(
                'label' => 'Channel Spy',
                'url' => 'admin.php?page=' . ytg_Core::$app->slug . '-channel',
            ),
            'options' => array(
                'label' => 'Options',
                'url' => 'admin.php?page=' . ytg_Core::$app->slug . '-admin-options',
            ),
        );
        if ('pro' != ytg_Core::config('edition')) {
            unset($this->layoutParams['headerTabs']['channel']);
        }

        //
        // Default layout params
        //
        $this->layoutParams['title'] = ytg_Core::config('plugin/title');
        $this->layoutParams['titleTools'] = NULL;

        $this->layoutParams['currentHeaderTab']  = 'admin'; // default value
    }

    public function redirect($url=array())
    {
        if (is_array($url)) {
            $url = ytg_Core::$app->view->adminUrl($url);
        }

        if (!headers_sent()) {
            wp_redirect($url);
            exit;
        }

        return $this->render('admin/redirect', compact('url'));
    }

    protected function _displayFormErrors(ytg_Framework_Model $model)
    {
        foreach ($model->getFirstErrors() as $error) {
            ytg_Core::$app->view->messages()->add($error, 'error');
        }
    }

    protected function _localizeGlobalParameter($globalName, $formName, $localName=NULL)
    {
        if (isset($_POST[$globalName])) {
            if (is_null($localName)) {
                $localName = $globalName;
            }
            
            if (!isset($_POST[$formName])) {
                $_POST[$formName] = array();
            }

            $_POST[$formName][$localName] = $_POST[$globalName];
            unset($_POST[$globalName]);
        }
    }
}
