<?php
ytg_Core::load('Controller_Base_Admin');

class ytg_Controller_Activate extends ytg_Controller_Base_Admin
{
    public function actionIndex()
    {
        /**
         * @var ytg_Component_Activate $model
         */
        $model = ytg_Core::$app->activate;
        if ($_POST) {
            if ($model->load($_POST) && $model->validate()) {
                try {
                    $result = $model->activate();
                    if (!$result) {
                        ytg_Core::$app->view->messages()->add(
                            "No license found for {$model->email}.", 'warning');
                    } else {
                        ytg_Core::$app->view->messages()->add(
                            ytg_Core::config('plugin/title') . ' has been successfully activated.',
                            'success');
                        $_POST = array();
                        return ytg_Core::$app->dispatch('admin');
                    }
                } catch (ytg_Component_Activate_Exception $e) {
                    ytg_Core::$app->view->messages()->add("Error sending activation request: {$e->getMessage()}",
                        'error');
                }

            } else {
                $this->_displayFormErrors($model);
            }
        }

        return $this->render('activate/index', compact('model'));
    }
}