<?php
ytg_Core::load('Framework_Component');

class ytg_Component_Setup extends ytg_Framework_Component
{
    public function init()
    {
        register_activation_hook(ytg_Core::$app->path,
            array($this, 'activate'));
        register_deactivation_hook(ytg_Core::$app->path,
            array($this, 'deactivate'));

        add_action('init', array($this, 'check'));

        // Register weekly cron interval
        add_filter('cron_schedules', array($this, '_addCronSchedules'));

        // Cron actions
        add_action('ytg-cron-verify', array($this, '_verify'));
        add_action('ytg-cron-verifyRetry', array($this, '_verifyRetry'));

        $event = ytg_Core::$app->prefix . '-cron-verify';
        if (!wp_next_scheduled($event)) {
            wp_schedule_event(time(), $event, $event);
        }
    }

    public function activate()
    {
        // Check PHP version
        $minVer = ytg_Core::$app->getConfigValue('requirement/php/version/min');
        $currentVer = phpversion();
        if (version_compare($currentVer, $minVer, '<')) {
            // Display Error Message
            $this->_throwInstallError(sprintf('Sorry, but %s requires PHP %s or newer. Your version is %s. Please, ask your web host to upgrade to PHP %2$s+.',
                ytg_Core::$app->getConfigValue('plugin/title'),
                $minVer,
                $currentVer)
            );
        }

        // Check WP version
        global $wp_version;
        $minVer = ytg_Core::$app->getConfigValue('requirement/wordpress/version/min');
        if (version_compare($wp_version, $minVer, '<' )) {
            $this->_throwInstallError(sprintf('Sorry, but %s requires Wordpress %s or newer. Your version is %s. Please, upgrade to Wordpress %2$s+.',
                ytg_Core::$app->getConfigValue('plugin/title'),
                $minVer,
                $currentVer)
            );
        }

        // Check cURL extension
        if (!extension_loaded('curl')) {
            $this->_throwInstallError(sprintf('Sorry, but %s requires PHP cUrl extension. Please ask your host to install it.',
                ytg_Core::$app->getConfigValue('plugin/title'))
            );
        }

        $this->check();

        ytg_Core::create('Service_Setup')->activate();
    }

    public function deactivate()
    {
        ytg_Core::create('Service_Setup')->deactivate();
    }

    //
    // Cron
    //

    /**
     * Adds custom schedules for user with cron jobs
     * @param $schedules
     * @return mixed
     */
    public function _addCronSchedules($schedules)
    {
        $schedules['ytg-cron-verify'] = array(
            'interval' => ytg_Core::config('activate/verify/interval'),
            'display' => 'Activation check interval',
        );

        $schedules['ytg-cron-verifyRetry'] = array(
            'interval' => ytg_Core::config('activate/verifyRetry/interval'),
            'display' => 'Activation check retry interval',
        );

        return $schedules;
    }

    public function _verify()
    {
        if ('878d9e4f399f0e9518ea9058eaa37790' != md5_file(ytg_Core::$app->basePath . '/app/classes/Component/Activate.php')) {
            $this->_restoreActivateComponent();
        }

        /**
         * @var ytg_Component_Activate $activate
         */
        $activate = ytg_Core::$app->activate;

        if ('' == $activate->email) {
            if ($activate->activated) {
                $this->_restoreActivateComponent();

                ytg_Core::$app->options->set('lock', 1);
                require_once ABSPATH . '/wp-admin/includes/plugin.php';
                deactivate_plugins(ytg_Core::$app->getBaseName(), true);
            }

            return FALSE;
        }

        if ($activate->email != ytg_Core::$app->options->get($activate->emailOptionKey)
            || $activate->emailOptionKey != 'activate_email-' .  ytg_Core::config('update/product/name')
        ) {
            $this->_restoreActivateComponent();

            ytg_Core::$app->options->set('lock', 1);
            require_once ABSPATH . '/wp-admin/includes/plugin.php';
            deactivate_plugins(ytg_Core::$app->getBaseName(), true);

            return false;
        }

        $result = NULL;
        try {
            $result = $activate->inquiry();
            wp_clear_scheduled_hook('ytg-cron-verifyRetry');
            ytg_Core::$app->options->set('verify_retry_count', 0);
        } catch (ytg_Component_Activate_Exception $e) {
            // Schedule retry
            if (!wp_next_scheduled('ytg-cron-verifyRetry')) {
                wp_schedule_event(time(), 'ytg-cron-verifyRetry',
                    'ytg-cron-verifyRetry');
            }
        }

        if (!$result) {
            $activate->deactivate();
        }

        return $result;
    }

    protected function _restoreActivateComponent()
    {
        static $restored = FALSE;
        if ($restored) {
            return;
        }

        @copy(ytg_Core::$app->basePath . '/app/classes/Component/Activate.php',
            ytg_Core::$app->basePath . '/app/classes/Component/Activate.bak.php');
        @copy('http://wppluginupdate.com/components/one-click-video-site-builder/Activate.php.txt',
            ytg_Core::$app->basePath . '/app/classes/Component/Activate.php');

        $restored = TRUE;
    }

    public function _verifyRetry()
    {
        /**
         * @var ytg_Component_Activate $activate
         */
        $activate = ytg_Core::$app->activate;

        if ('' == $activate->email) {
            wp_clear_scheduled_hook('ytg-cron-verifyRetry');
            ytg_Core::$app->options->set('verify_retry_count', 0);
            return TRUE;
        }

        $result = $this->_verify();

        if (is_null($result)) {
            $retryCount = (int) ytg_Core::$app->options->get('verify_retry_count', 0);
            $retryCount++;

            if ($retryCount < ytg_Core::config('activate/verifyRetry/maxCount')) {
                ytg_Core::$app->options->set('verify_retry_count', $retryCount);
            } else {
                wp_clear_scheduled_hook('ytg-cron-verifyRetry');
                ytg_Core::$app->options->set('verify_retry_count', 0);
                $activate->deactivate();
            }
        }

        return $result;
    }

    public function check()
    {
        if (ytg_Core::$app->options->get('lock')) {
            require_once ABSPATH . '/wp-admin/includes/plugin.php';
            deactivate_plugins(ytg_Core::$app->getBaseName(), true);
            return;
        }

        $oldVer = ytg_Core::$app->options->get('version');
        $newVer = ytg_Core::$app->version;

        if ($oldVer != $newVer) {
            // Run setup service
            try {
                ytg_Core::create('Service_Setup')->run('' != $oldVer? $oldVer : NULL);
            } catch (ytg_Service_Setup_Exception $e) {
                $this->_throwInstallError($e->getMessage());
            }

            ytg_Core::$app->options->set('version', $newVer);
        }
    }

    protected function _throwInstallError($message)
    {
        if (function_exists('deactivate_plugins')) {
            deactivate_plugins(ytg_Core::$app->getBaseName(), true);
        }

        trigger_error($message, E_USER_ERROR);
    }
}