<?php
ytg_Core::load('Framework_Component');

class ytg_Component_Cron extends ytg_Framework_Component
{
    public function init()
    {
        add_action(ytg_Core::$app->prefix . '_check_channels',
            array($this, 'checkChannels'));
    }

    public function checkChannels($force = FALSE)
    {
        if (!$force && !$this->_needCheckChannels()) {
            return;
        }

        $now = time();

        $log = "\nDone.";
        $status = 'success';

        @set_time_limit(36000);
        @ini_set('memory_limit', '512M');

        try {
            ytg_Core::$app->generator->checkChannels();
        } catch (ytg_Component_Process_FailedException $e) {
            $log = "{$e->getMessage()}\n\nFailed.";
            $status = 'error';

        } catch (ytg_Component_Process_FatalException $e) {
            $log = "{$e->getMessage()}\n\nFailed.";
            $status = 'error';

        } catch (ytg_Component_Process_CriticalException $e) {
            $log = "Critical error: {$e->getMessage()}\n\n"
                . "Debug trace: \n{$e->getTraceAsString()}\n\n"
                . "Critical error occurred. Please contact plugin support.";
            $status = 'error';

        } catch (Exception $e) {
            $log = "Unexpected error: {$e}\n\n"
                . "Unexpected error occurred. Please contact plugin support.";
            $status = 'error';
        }

        ytg_Core::$app->options->set('lastChannelCheckTimestamp', $now);
        ytg_Core::$app->options->set('lastChannelCheckLog',
            ytg_Core::$app->generator->log . $log);
        ytg_Core::$app->options->set('lastChannelCheckStatus', $status);
    }

    protected function _needCheckChannels()
    {
        $lastCheck = ytg_Core::$app->options->get('lastChannelCheckTimestamp');
        if (is_null($lastCheck)) {
            return TRUE;
        }

        $delta = round((time() - $lastCheck) / 86400);

        return $delta >= ytg_Core::$app->options->get('channelCheckInterval');
    }

    /**
     * Generates Cron job for setup with cPanel
     * @return array
     */
    public function generateCronJob()
    {
        $command = 'wget -q -O - ' . site_url('', 'http')
            . '/wp-cron.php?doing_wp_cron >/dev/null 2>&1';

        return array(
            'month' => '*',
            'weekday' => '*',
            'day' => '*',
            'hour' => '0',
            'minute' => '0',
            'command' => $command,
        );
    }
}