<?php
ytg_Core::load('Framework_Service');

class ytg_Component_BadWordsFilter extends ytg_Framework_Component
{
    public $list;
    public $pattern;

    public function init()
    {
        parent::init();

        if (is_null($this->pattern)) {
            $list = is_null($this->list)
                ? ytg_Core::$app->loadConfig('bad-words')
                : $this->list;

            foreach ($list as &$value) {
                $value = preg_quote($value, '~');
            }
        
            $list = implode('|', $list);

            $this->pattern = "~\b(?:{$list})\b~isu"; 
        }
    }

    public function hasBadWords($text)
    {
        return (bool) preg_match($this->pattern, $text, $matches);
    }
}